--[[---------------------------------------------------------------------------
	Chocolatier Two Standard Item Buy/Sell
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local item = gDialogTable.item
local itemName = item.name
gNumberPadTarget = itemName

local w = 460
local h = 230

-------------------------------------------------------------------------------

local function cancelFunction()
	gNumberPadCallback = nil
	gNumberPadTarget = nil
	CloseWindow()
end

local function okFunction()
	local v = GetLabel(gNumberPadTarget)
	gNumberPadCallback = nil
	gNumberPadTarget = nil
	CloseWindow(v)
end

gNumberPadCallback = function()
	local v = GetLabel(gNumberPadTarget)
	v = tonumber(v) or 0
	
	-- Can't sell more than you own or buy more than you can afford
	if item.recipe and v > item.inventory then
		v = item.inventory
		SetLabel(gNumberPadTarget, tostring(v))
	elseif (not item.recipe) and v * item.price > gSim.money then
--		v = bsgFloor(gSim.money / item.price)
--		SetLabel(gNumberPadTarget, tostring(v))
	end
	
	-- Calculate total
	local n = tonumber(v) or 0
	local total = n * item.price
	local s = tostring(n) .. " x " .. bsgDollars(item.price) .. " = " .. bsgDollars(total)
	
	-- Check for more than you can buy
	if not item.recipe and total > gSim.money then s = "<font color='ee2222'>" .. s end
	
	if n == 0 then s = "" end
	SetLabel("subtotal", s)
	SetFocus(gNumberPadTarget)
end

-------------------------------------------------------------------------------

local ask = bsgDollars(item.price)
local buysell = "buy"
if item.recipe then buysell = "sell" end
ask = "#"..GetString(buysell.."_howmany", ask)

local fh = bsgFontHeight(dialogFont)
local buttonY = 128 + 3*fh
local xLeft = w/2 - ui.devButtonW - 5
local xRight = kMax - xLeft - ui.devButtonW
local xPad = w/2 - 184/2
MakeDialog
{
	Frame
	{
		x=290,y=ui.yOffset+85,w=w,h=h,color=DialogColor,fit=true,
		
		item:BigRollover(5,5,1),
		Text { x=70,y=0,w=kMax,h=fh, label=LabelString(itemName), flags=kHAlignLeft+kVAlignCenter },
		Text { x=70,y=fh,w=kMax,h=fh, label=ask, flags=kHAlignLeft+kVAlignCenter },

		Text { x=xPad,y=2*fh, w=kMax,h=fh, name="subtotal", flags=kHAlignLeft+kVAlignCenter },
		NumberPad(xPad,3*fh, item.name),
		TextEdit { x=xPad+50,y=3*fh+6, w=85,h=29, name=item.name, length=7, label="" },
		TextButton { x=xLeft,y=buttonY, command=okFunction, label=buysell, },
		TextButton { x=xRight,y=buttonY, command=cancelFunction, label="cancel", default=true, },
		
		-- HACK - in Beta, this is the only mechanism I have to respond to edit changes
		DynamicWindow { x=0,y=0,w=1,h=1, ontext=true, script="if gNumberPadCallback then gNumberPadCallback() end" },
	}
}

-- Only enable "MAX" button when selling
if not item.recipe then EnableWindow("number_max", false) end
gNumberPadCallback()
SetFocus(item.name)
